function cm = getColorMap(num_colors)
%GETCOLORMAP    Return default k-Wave color map.
%
% DESCRIPTION:
%       getColorMap returns the default color map used for display and
%       visualisation across the k-Wave Toolbox. Zero values are displayed
%       as white, positive values are displayed as yellow through red to
%       black, and negative values are displayed as light to dark
%       blue-greys. If no value for num_colors is provided, cm will have
%       256 colors.    
%
% USAGE:
%       cm = getColorMap()
%       cm = getColorMap(num_colors)
%
% OPTIONAL INPUTS:
%       num_colors  - number of colors in the color map (default = 256)
%
% OUTPUTS:
%       cm          - three column color map matrix which can be applied
%                     using colormap
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 3rd July 2009
%       last update - 17th July 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
%
% See also colormap

% set literals
if nargin == 0
    neg_pad = 48;
    num_colors = 256;   
else
    neg_pad = round(48*num_colors/256);
end

% define colour spectrums
neg = bone(num_colors/2 + neg_pad);
neg = neg(1 + neg_pad:end, :);
pos = flipud(hot(num_colors/2));

% create custom colour map
cm = [neg; pos];